package net.mandaria.tippytipper.test;

import net.mandaria.tippytipper.activities.TippyTipper;
import com.robotium.solo.*;
import android.test.ActivityInstrumentationTestCase2;


public class TippyTipperTest extends ActivityInstrumentationTestCase2<TippyTipper> {
  	private Solo solo;
  	
  	public TippyTipperTest() {
		super(TippyTipper.class);
  	}

  	public void setUp() throws Exception {
        super.setUp();
		solo = new Solo(getInstrumentation());
		getActivity();
  	}
  
   	@Override
   	public void tearDown() throws Exception {
        solo.finishOpenedActivities();
        super.tearDown();
  	}
  
	public void testRun() {
		// Wait for activity: 'net.mandaria.tippytipper.activities.TippyTipper'
		solo.waitForActivity(net.mandaria.tippytipper.activities.TippyTipper.class, 2000);

		// Click on net.mandaria.tippytipper.R$id.btn_two
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_two));
		// Click on net.mandaria.tippytipper.R$id.btn_three
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_three));
		// Click on net.mandaria.tippytipper.R$id.btn_five
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_five));
		// Click on net.mandaria.tippytipper.R$id.btn_one
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		// Click on net.mandaria.tippytipper.R$id.btn_two
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_two));
		// Click on Calculate!
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));


		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		// Click on 10%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click on 15%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		// Click on 20%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(net.mandaria.tippytipper.R.id.seek_tip_percentage), 8);



		// Click on Round Down
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Click on Round Up
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));


		// Click on Split Bill
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		// Wait for activity: 'net.mandaria.tippytipper.activities.SplitBill'
		assertTrue("net.mandaria.tippytipper.activities.SplitBill is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.SplitBill.class));
		// Click on net.mandaria.tippytipper.R$id.btn_remove_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_remove_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Click on net.mandaria.tippytipper.R$id.btn_add_person
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_add_person));
		// Press menu back key
		solo.goBack();
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.settings);
		// Wait for activity: 'net.mandaria.tippytipper.activities.Settings'
		assertTrue("net.mandaria.tippytipper.activities.Settings is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Settings.class));
		// Click on Default Tip Percentage Percentage to tip by default LinearLayout
		solo.clickInList(2, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 14);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Click on First Tip Percentage Custom value for first tip percentage preset button Li
		solo.clickInList(3, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 12);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Click on Second Tip Percentage Custom value for second tip percentage preset button 
		solo.clickInList(4, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 16);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Click on Third Tip Percentage Custom value for third tip percentage preset button Li
		solo.clickInList(5, 0);
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Set progress on SeekBar
		solo.setProgressBar((android.widget.ProgressBar) solo.getView(android.widget.SeekBar.class, 0), 21);
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Scroll to Enable Exclude Tax Rate Excludes tax rate from tip when enabled LinearLayout
		android.widget.ListView listView0 = (android.widget.ListView) solo.getView(android.widget.ListView.class, 0);
		solo.scrollListToLine(listView0, 4);
		// Click on Enable Exclude Tax Rate Excludes tax rate from tip when enabled LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Enable Exclude Tax Rate"));
		// Click on Tax Rate to Exclude The tax rate to exclude when calculating tip LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Tax Rate to Exclude"));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Enter the text: '23'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "23");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Click on Round Type Choose to round by tip or total LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Round Type"));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on Round Tip
		solo.clickOnView(solo.getView(android.R.id.text1));
		// Click on Default Number People The number of people to split bill by LinearLayout
		solo.clickOnText(java.util.regex.Pattern.quote("Default Number People"));
		// Wait for dialog
		solo.waitForDialogToOpen(5000);
		// Click on ImageView
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.increment));
		// Enter the text: '3'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.timepicker_input), "3");
		// Click on OK
		solo.clickOnView(solo.getView(android.R.id.button1));
		// Click on Enable Error Logging Application reports anonymous error/event information 
		solo.clickOnText(java.util.regex.Pattern.quote("Enable Error Logging"));
		// Press menu back key
		solo.goBack();
		// Click on DEL
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_delete));
		// Click on CLEAR
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_clear));
		// Click on net.mandaria.tippytipper.R$id.btn_one
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_one));
		// Click on net.mandaria.tippytipper.R$id.btn_two
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_two));
		// Click on net.mandaria.tippytipper.R$id.btn_three
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_three));
		// Click on net.mandaria.tippytipper.R$id.btn_six
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_six));
		// Click on net.mandaria.tippytipper.R$id.btn_zero
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_zero));
		// Click on net.mandaria.tippytipper.R$id.btn_two
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_two));
		// Enter the text: '$1,236.02'
		solo.clearEditText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount));
		solo.enterText((android.widget.EditText) solo.getView(net.mandaria.tippytipper.R.id.txt_amount), "$1,236.02");
		// Click on Calculate!
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_ok));
		// Wait for activity: 'net.mandaria.tippytipper.activities.Total'
		assertTrue("net.mandaria.tippytipper.activities.Total is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.Total.class));
		// Click on 12%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount1));
		// Click on 16%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount2));
		// Click on 21%
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_TipAmount3));
		// Click on Round Down
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_down));
		// Click on Round Up
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_round_up));
		// Click on Split Bill
		solo.clickOnView(solo.getView(net.mandaria.tippytipper.R.id.btn_SplitBill));
		// Wait for activity: 'net.mandaria.tippytipper.activities.SplitBill'
		assertTrue("net.mandaria.tippytipper.activities.SplitBill is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.SplitBill.class));
		// Press menu back key
		solo.goBack();
		// Press menu back key
		solo.goBack();
		// Click on action bar item
		solo.clickOnActionBarItem(net.mandaria.tippytipper.R.id.about);
		// Wait for activity: 'net.mandaria.tippytipper.activities.About'
		assertTrue("net.mandaria.tippytipper.activities.About is not found!", solo.waitForActivity(net.mandaria.tippytipper.activities.About.class));
		// Press menu back key
		solo.goBack();
	}
}
